<?php

namespace App\Model;

class Kid extends Eloquent {

	protected $table = 'kids';
	public $timestamps = true;
	protected $fillable = array('username', 'father_id');

	public function homework()
	{
		return $this->hasMany('App\Model\Homework');
	}

	public function absence()
	{
		return $this->morphMany('App\Model\Absence');
	}

	public function father()
	{
		return $this->hasOne('App\Model\Father');
	}

	public function payment()
	{
		return $this->hasOne('App\Model\Payment');
	}

	public function teacher()
	{
		return $this->hasMany('App\Model\Teacher');
	}

	public function tasmeea()
	{
		return $this->hasMany('App\Model\Tasmeea');
	}

}