<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->string('firstname', 100)->nullable();
			$table->string('lastname', 100)->nullable();
			$table->string('email')->unique();
			$table->string('password');
			$table->string('zip_code', 10)->nullable();
			$table->string('address', 255)->nullable();
			$table->string('city', 100)->nullable();
			$table->string('phone', 20)->nullable();
			$table->string('remember_token', 100);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}