<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('phones', function(Blueprint $table) {
			$table->foreign('club_id')->references('id')->on('clubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stadiums', function(Blueprint $table) {
			$table->foreign('club_id')->references('id')->on('clubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('stadiums', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clubs', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('Owners')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clubs', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('club_schedule', function(Blueprint $table) {
			$table->foreign('club_id')->references('id')->on('clubs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Stadium_schedule', function(Blueprint $table) {
			$table->foreign('stadium_id')->references('id')->on('stadiums')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('booking_prices', function(Blueprint $table) {
			$table->foreign('stadium_id')->references('id')->on('Stadium_schedule')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('phones', function(Blueprint $table) {
			$table->dropForeign('phones_club_id_foreign');
		});
		Schema::table('stadiums', function(Blueprint $table) {
			$table->dropForeign('stadiums_club_id_foreign');
		});
		Schema::table('stadiums', function(Blueprint $table) {
			$table->dropForeign('stadiums_category_id_foreign');
		});
		Schema::table('clubs', function(Blueprint $table) {
			$table->dropForeign('clubs_owner_id_foreign');
		});
		Schema::table('clubs', function(Blueprint $table) {
			$table->dropForeign('clubs_area_id_foreign');
		});
		Schema::table('club_schedule', function(Blueprint $table) {
			$table->dropForeign('club_schedule_club_id_foreign');
		});
		Schema::table('Stadium_schedule', function(Blueprint $table) {
			$table->dropForeign('Stadium_schedule_stadium_id_foreign');
		});
		Schema::table('booking_prices', function(Blueprint $table) {
			$table->dropForeign('booking_prices_stadium_id_foreign');
		});
	}
}