<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $hidden = array('password');

	public function queues()
	{
		return $this->hasMany('Queue');
	}

	public function clients()
	{
		return $this->hasMany('Client');
	}

}