<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecordingsTable extends Migration {

	public function up()
	{
		Schema::create('recordings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('transcription_id')->unsigned()->index();
			$table->string('recording_url', 255)->nullable();
			$table->integer('field_id')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('recordings');
	}
}