<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('finish_level_items', function(Blueprint $table) {
			$table->foreign('finish_level_id')->references('name')->on('finish_levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('finish_level_items', function(Blueprint $table) {
			$table->foreign('finish_item_id')->references('id')->on('finish_level_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('finish_calcs', function(Blueprint $table) {
			$table->foreign('execuation_duration_id')->references('id')->on('execuation_durations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('finish_calcs', function(Blueprint $table) {
			$table->foreign('finish_item_id')->references('id')->on('finish_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('finish_calcs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('finish_calcs', function(Blueprint $table) {
			$table->foreign('finish_level_id')->references('id')->on('finish_levels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('finish_area_items', function(Blueprint $table) {
			$table->foreign('finish_area_type_id')->references('id')->on('area_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('finish_area_items', function(Blueprint $table) {
			$table->foreign('finish_item_id')->references('id')->on('finish_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('finish_level_items', function(Blueprint $table) {
			$table->dropForeign('finish_level_items_finish_level_id_foreign');
		});
		Schema::table('finish_level_items', function(Blueprint $table) {
			$table->dropForeign('finish_level_items_finish_item_id_foreign');
		});
		Schema::table('finish_calcs', function(Blueprint $table) {
			$table->dropForeign('finish_calcs_execuation_duration_id_foreign');
		});
		Schema::table('finish_calcs', function(Blueprint $table) {
			$table->dropForeign('finish_calcs_finish_item_id_foreign');
		});
		Schema::table('finish_calcs', function(Blueprint $table) {
			$table->dropForeign('finish_calcs_user_id_foreign');
		});
		Schema::table('finish_calcs', function(Blueprint $table) {
			$table->dropForeign('finish_calcs_finish_level_id_foreign');
		});
		Schema::table('finish_area_items', function(Blueprint $table) {
			$table->dropForeign('finish_area_items_finish_area_type_id_foreign');
		});
		Schema::table('finish_area_items', function(Blueprint $table) {
			$table->dropForeign('finish_area_items_finish_item_id_foreign');
		});
	}
}