<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Availability extends Eloquent {

	protected $table = 'availabilities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function independentProAvailabilities()
	{
		return $this->hasMany('IndependentProfessionals', 'availability_id', 'id');
	}

	public function shopOwnerAvailabilities()
	{
		return $this->hasMany('ShopOwner', 'user_id', 'id');
	}

}