<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfessionalsTable extends Migration {

	public function up()
	{
		Schema::create('professionals', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('availability_id')->unsigned();
			$table->string('doc1', 191);
			$table->string('doc2', 191);
			$table->string('professional_name', 191);
			$table->longText('description');
			$table->integer('availability_hours');
			$table->float('average_rating');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('professionals');
	}
}