<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceBooksTable extends Migration {

	public function up()
	{
		Schema::create('service_books', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->bigInteger('service_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('charges');
			$table->time('estimated_time');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('service_books');
	}
}