<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractChairsTable extends Migration {

	public function up()
	{
		Schema::create('contract_chairs', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('shop_id')->unsigned();
			$table->bigInteger('dependent_pro_id')->unsigned();
			$table->string('timing', 191);
			$table->string('expiry', 191);
			$table->string('percentage', 191);
			$table->string('location', 191);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contract_chairs');
	}
}