<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('estore_id')->unsigned();
			$table->bigInteger('user_id_customer')->unsigned();
			$table->string('email', 191);
			$table->bigInteger('phone_number');
			$table->string('shipping_address', 191);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}