<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('firstname')->nullable();
			$table->string('email')->unique();
			$table->string('password');
			$table->string('avatar_file')->nullable();
			$table->date('birthdate')->nullable();
			$table->string('gender')->nullable();
			$table->string('phone_number')->nullable();
			$table->boolean('is_whatsApp')->default(false);
			$table->date('register_date');
			$table->string('facebook_id')->nullable();
			$table->string('google_id')->nullable();
			$table->string('github_id')->nullable();
			$table->string('ip_address');
			$table->datetime('last_login')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}