<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Experience extends Eloquent {

	protected $table = 'experiences';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('society', 'title', 'start_date', 'end_date', 'description', 'sector_id', 'town_id', 'profile_id');

	public function town()
	{
		return $this->belongsTo('App\Models\Town', 'town_id');
	}

	public function sector()
	{
		return $this->belongsTo('App\Models\Sector', 'sector_id');
	}

	public function skills()
	{
		return $this->belongsToMany('App\Models\Skill');
	}

}