<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Recommendation extends Eloquent {

	protected $table = 'recommendations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('enterprise', 'title', 'comment', 'author_id', 'profile_id');

	public function author()
	{
		return $this->belongsTo('App\Models\User', 'author_id');
	}

}