<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFormationsTable extends Migration {

	public function up()
	{
		Schema::create('formations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('degree');
			$table->string('school');
			$table->date('graduation_year');
			$table->longText('description')->nullable();
			$table->bigInteger('profile_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('formations');
	}
}