<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecommendationsTable extends Migration {

	public function up()
	{
		Schema::create('recommendations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('enterprise', 50);
			$table->string('title', 50);
			$table->longText('comment');
			$table->bigInteger('author_id')->unsigned();
			$table->bigInteger('profile_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('recommendations');
	}
}