<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Mission extends Eloquent {

	protected $table = 'missions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'type', 'in_office', 'start_period', 'duration', 'description', 'status', 'phone_number', 'is_whatsApp', 'company_name', 'company_size', 'user_id');

	public function skills()
	{
		return $this->belongsToMany('App\Models\Skill');
	}

}