<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Profile extends Eloquent {

	protected $table = 'profiles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('activity', 'is_mobile', 'on_full_time', 'price', 'slug', 'description', 'is_available', 'availability_date', 'is_verified', 'is_certified', 'user_id', 'town_id', 'experience_year_id');

	public function skills()
	{
		return $this->belongsToMany('App\Models\Skill');
	}

	public function experiences()
	{
		return $this->hasMany('App\Models\Experience');
	}

	public function portfolios()
	{
		return $this->hasMany('App\Models\Portfolio');
	}

	public function missions()
	{
		return $this->belongsToMany('App\Models\Mission');
	}

	public function formations()
	{
		return $this->hasMany('App\Models\Formation');
	}

	public function trades()
	{
		return $this->belongsToMany('App\Models\Trade');
	}

	public function town()
	{
		return $this->belongsTo('App\Models\Town');
	}

	public function experienceYear()
	{
		return $this->belongsTo('App\Models\ExperienceYear', 'experience_year_id');
	}

	public function languages()
	{
		return $this->belongsToMany('App\Models\Language');
	}

	public function recommendations()
	{
		return $this->hasMany('App\Models\Recommendation');
	}

}