<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMissionsTable extends Migration {

	public function up()
	{
		Schema::create('missions', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 80);
			$table->string('type');
			$table->boolean('in_office')->default(false);
			$table->string('start_period');
			$table->string('duration');
			$table->longText('description');
			$table->string('status');
			$table->string('phone_number');
			$table->boolean('is_whatsApp')->default(false);
			$table->string('company_name');
			$table->string('company_size');
			$table->bigInteger('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('missions');
	}
}