<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFleetsTable extends Migration {

	public function up()
	{
		Schema::create('fleets', function(Blueprint $table) {
			$table->bigInteger('id')->primary()->index();
			$table->timestamps();
			$table->text('motd')->nullable();
			$table->boolean('is_free_move');
			$table->datetime('start_time')->nullable()->index();
			$table->datetime('stop_time')->nullable()->index();
			$table->bigInteger('added_by')->index();
		});
	}

	public function down()
	{
		Schema::drop('fleets');
	}
}