<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePannelsModelsTable extends Migration {

	public function up()
	{
		Schema::create('pannels_models', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('make_id')->unsigned();
			$table->string('height')->nullable();
			$table->float('height_value');
			$table->string('width');
			$table->float('width_value');
			$table->integer('cells');
			$table->string('power');
			$table->float('power_value');
			$table->timestamps();
			$table->softDeletes();
			$table->string('label_en', 254);
			$table->string('type_en', 254);
			$table->string('label_fr', 254);
			$table->string('type_fr', 254);
		});
	}

	public function down()
	{
		Schema::drop('pannels_models');
	}
}