<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAraysTable extends Migration {

	public function up()
	{
		Schema::create('arays', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('zone_id')->unsigned();
			$table->string('name', 255);
			$table->string('distance');
			$table->float('distance_value');
			$table->integer('nb_strings');
			$table->integer('nb_pannels');
			$table->string('installed_capacity');
			$table->float('installed_capacity_value');
			$table->enum('starting_point', array('lat', 'long'));
			$table->enum('ending_point', array('lat', 'long'));
			$table->enum('direction', array('val1', 'val2'));
			$table->timestamps();
			$table->integer('order')->default('0');
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('arays');
	}
}