<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDatasTable extends Migration {

	public function up()
	{
		Schema::create('datas', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('account_id')->unsigned();
			$table->integer('account_type_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('gender_id')->unsigned();
			$table->integer('Country_id')->unsigned();
			$table->integer('region_id')->unsigned();
			$table->integer('piece_jointes_id')->unsigned();
			$table->string('role');
			$table->string('owner', 254);
			$table->string('SPV', 254);
			$table->string('Address', 254);
			$table->string('zip_code', 254);
			$table->string('first_name', 254);
			$table->string('name', 254);
			$table->string('cell_phone', 254);
			$table->string('fixed_phone', 254);
			$table->string('email', 254);
			$table->string('job_title', 254);
			$table->string('path', 254)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('datas');
	}
}