<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateControlePointsTable extends Migration {

	public function up()
	{
		Schema::create('controle_points', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->float('Expected_value_1');
			$table->float('Expected_value_2');
			$table->integer('phase_point_controle_id')->unsigned();
			$table->integer('focuses_id')->unsigned();
			$table->integer('purposes_id')->unsigned();
			$table->integer('assessment_types_id')->unsigned();
			$table->integer('expected_accuracies_id')->unsigned();
			$table->integer('stakes_id')->unsigned();
			$table->integer('controle_types_id')->unsigned();
			$table->integer('controle_id')->unsigned();
			$table->string('author', 255);
			$table->string('label', 255);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('controle_points');
	}
}