<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ComponentModel extends Eloquent {

	protected $table = 'components_models';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function make()
	{
		return $this->belongsTo('Make');
	}

	public function components()
	{
		return $this->hasMany('Component');
	}

}