<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Controle extends Eloquent {

	protected $table = 'controles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function sites()
	{
		return $this->belongsToMany('Site');
	}

	public function phase()
	{
		return $this->belongsTo('Phase');
	}

	public function asset()
	{
		return $this->belongsTo('Asset');
	}

	public function inspection()
	{
		return $this->belongsTo('Inspection');
	}

	public function maintenance_type()
	{
		return $this->belongsTo('MaintenanceType');
	}

	public function installation_type()
	{
		return $this->belongsTo('Installation_type');
	}

	public function related_servicing()
	{
		return $this->belongsTo('Related_servicing');
	}

	public function inspection_frequency()
	{
		return $this->belongsTo('Inspection_frequency');
	}

	public function controle_points()
	{
		return $this->hasMany('Controle_point');
	}

	public function planifications()
	{
		return $this->belongsToMany('Planification');
	}

}