<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Country extends Eloquent {

	protected $table = 'countries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function datas()
	{
		return $this->hasMany('Data');
	}

	public function regions()
	{
		return $this->hasMany('Region');
	}

	public function sites()
	{
		return $this->hasMany('Site');
	}

}