<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Planification extends Eloquent {

	protected $table = 'planifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function asset()
	{
		return $this->belongsTo('Asset');
	}

	public function maintenance_type()
	{
		return $this->belongsTo('MaintenanceType');
	}

	public function controle()
	{
		return $this->belongsToMany('Controle');
	}

	public function site()
	{
		return $this->belongsTo('Site');
	}

}