<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Region extends Eloquent {

	protected $table = 'regions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function country()
	{
		return $this->belongsTo('Country');
	}

	public function cities()
	{
		return $this->hasMany('City');
	}

}