<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Shelter extends Eloquent {

	protected $table = 'shelters';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function zone()
	{
		return $this->belongsTo('Zone');
	}

	public function components()
	{
		return $this->hasMany('Component');
	}

}