<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompanyServiceTable extends Migration {

	public function up()
	{
		Schema::create('company_service', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->date('service_start_date')->nullable()->index();
			$table->date('service_end_date')->nullable();
			$table->integer('service_provider')->unsigned()->index();
			$table->integer('inquiry_id')->unsigned();
			$table->integer('service_id')->unsigned();
			$table->integer('service_value')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('company_service');
	}
}