<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email')->unique();
			$table->string('first_name');
			$table->string('last_name');
			$table->rememberToken('rememberToken');
			$table->string('password');
			$table->boolean('active')->default(true);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}