<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInventoriesTable extends Migration {

	public function up()
	{
		Schema::create('inventories', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('product_id')->unsigned();
			$table->date('purchase_date')->nullable();
			$table->bigInteger('order_id')->unsigned();
			$table->decimal('buying_price', 10,2)->nullable();
			$table->decimal('selling_price', 10,2)->nullable();
			$table->mediumInteger('cr')->unsigned()->nullable();
			$table->mediumInteger('dr')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('inventories');
	}
}