<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('parent_id')->unsigned();
			$table->string('username', 100);
			$table->string('password');
			$table->tinyInteger('type')->default('2');
			$table->bigInteger('created_by')->unsigned();
			$table->string('created_by_ip', 15);
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->string('updated_by_ip', 15)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}