<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('order_id')->unsigned();
			$table->date('order_date');
			$table->string('shipping_address');
			$table->string('mobile_no', 15);
			$table->decimal('net_amount', 10,2);
			$table->tinyInteger('status')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}