<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestStatusTable extends Migration {

	public function up()
	{
		Schema::create('request_status', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('request_id');
			$table->string('request_type');
			$table->bigInteger('user_id')->unsigned();
			$table->enum('status', array('pending', 'delivered', 'in_transaction', 'need_approved', 'out_transaction', 'in_verification', 'installed', 'faulty'));
			$table->text('description');
			$table->text('notes')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('request_status');
	}
}