<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMetersTable extends Migration {

	public function up()
	{
		Schema::create('meters', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('item_id')->unsigned();
			$table->float('quantity');
			$table->string('serial_number');
			$table->enum('item_status', array('new', 'used', 'dismantled'));
			$table->enum('returned_reason', array('faulty', 'operated'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('meters');
	}
}