<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutRequestsTable extends Migration {

	public function up()
	{
		Schema::create('out_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('work_order_id');
			$table->integer('nokia_requester_id')->unsigned();
			$table->integer('entity_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->integer('stream_id')->unsigned();
			$table->text('notes');
			$table->integer('site_id')->unsigned();
			$table->integer('subcontractor_id')->unsigned()->nullable();
			$table->integer('internal_supplier_id')->unsigned()->nullable();
			$table->integer('site_engineer_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('out_requests');
	}
}