<?php

namespace App\Models;

class Site extends Eloquent {

	protected $table = 'sites';
	public $timestamps = true;
	protected $fillable = array('name', 'code', 'user_id');

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function in_requests()
	{
		return $this->hasMany('App\Models\InRequest');
	}

	public function out_requests()
	{
		return $this->hasMany('App\Models\OutRequest');
	}

}