<?php

namespace App;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'phone', 'password');
	protected $hidden = array('password');

	public function items()
	{
		return $this->hasMany('App\Models\Item');
	}

	public function in_requests()
	{
		return $this->hasMany('App\Models\InRequest');
	}

	public function sites()
	{
		return $this->hasMany('App\Models\Site');
	}

	public function out_requests()
	{
		return $this->hasMany('App\Models\OutRequest');
	}

	public function delivered_in_requests()
	{
		return $this->hasMany('App\Models\InRequest', 'delivery_id');
	}

}