<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('location_group_id')->references('id')->on('location_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_template_Place_holders', function(Blueprint $table) {
			$table->foreign('email_template_id')->references('id')->on('email_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_template_distribution_lists', function(Blueprint $table) {
			$table->foreign('email_template_id')->references('id')->on('email_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('email_template_distribution_lists', function(Blueprint $table) {
			$table->foreign('distribution_list_group_id')->references('id')->on('distribution_list_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->foreign('email_id')->references('id')->on('emails')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_location_group_id_foreign');
		});
		Schema::table('email_template_Place_holders', function(Blueprint $table) {
			$table->dropForeign('email_template_Place_holders_email_template_id_foreign');
		});
		Schema::table('email_template_distribution_lists', function(Blueprint $table) {
			$table->dropForeign('email_template_distribution_lists_email_template_id_foreign');
		});
		Schema::table('email_template_distribution_lists', function(Blueprint $table) {
			$table->dropForeign('email_template_distribution_lists_distribution_list_group_id_foreign');
		});
		Schema::table('attachments', function(Blueprint $table) {
			$table->dropForeign('attachments_email_id_foreign');
		});
	}
}