<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationClientsTable extends Migration {

	public function up()
	{
		Schema::create('notification_clients', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('client_id')->unsigned();
			$table->text('message')->nullable();
			$table->boolean('read')->default(false);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('notification_clients');
	}
}