<?php

namespace App\Models\Trajet;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Trajet extends Eloquent {

	protected $table = 'trajets';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function type_trajet()
	{
		return $this->belongsTo('App\Models\TypeTrajet\TypeTrajet');
	}

	public function commandes()
	{
		return $this->hasMany('App\Models\Commandes\Commande');
	}

}