<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('invitations', function(Blueprint $table) {
			$table->foreign('bm_id')->references('id')->on('akds')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('invitation_lists', function(Blueprint $table) {
			$table->foreign('invitation_id')->references('id')->on('invitations')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('invitation_lists', function(Blueprint $table) {
			$table->foreign('bm_id')->references('id')->on('bms')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('akd_schedules', function(Blueprint $table) {
			$table->foreign('bm_id')->references('id')->on('bms')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('akd_schedules', function(Blueprint $table) {
			$table->foreign('akd_id')->references('id')->on('akds')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('akd_schedules', function(Blueprint $table) {
			$table->foreign('legend_id')->references('id')->on('legends')
						->onDelete('set null')
						->onUpdate('restrict');
		});
		Schema::table('dprd_schedules', function(Blueprint $table) {
			$table->foreign('bm_id')->references('id')->on('bms')
						->onDelete('set null')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('invitations', function(Blueprint $table) {
			$table->dropForeign('invitations_bm_id_foreign');
		});
		Schema::table('invitation_lists', function(Blueprint $table) {
			$table->dropForeign('invitation_lists_invitation_id_foreign');
		});
		Schema::table('invitation_lists', function(Blueprint $table) {
			$table->dropForeign('invitation_lists_bm_id_foreign');
		});
		Schema::table('akd_schedules', function(Blueprint $table) {
			$table->dropForeign('akd_schedules_bm_id_foreign');
		});
		Schema::table('akd_schedules', function(Blueprint $table) {
			$table->dropForeign('akd_schedules_akd_id_foreign');
		});
		Schema::table('akd_schedules', function(Blueprint $table) {
			$table->dropForeign('akd_schedules_legend_id_foreign');
		});
		Schema::table('dprd_schedules', function(Blueprint $table) {
			$table->dropForeign('dprd_schedules_bm_id_foreign');
		});
	}
}