<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBmsTable extends Migration {

	public function up()
	{
		Schema::create('bms', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('label', 191)->index()->default('NULL');
			$table->text('description')->nullable();
			$table->datetime('start_date')->index();
			$table->string('day', 191)->index()->default('NULL');
			$table->string('place', 191)->index();
			$table->text('agenda');
		});
	}

	public function down()
	{
		Schema::drop('bms');
	}
}