<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AkdSchedule extends Eloquent {

	protected $table = 'akd_schedules';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('bm_id', 'name', 'schedule_date', 'akd_id', 'legend_id');
	protected $visible = array('name', 'schedule_date');

	public function getBamusMeetimg()
	{
		return $this->hasOne('BamusMeeting');
	}

	public function getAkd()
	{
		return $this->hasOne('Akd');
	}

	public function getLegend()
	{
		return $this->hasOne('Legend');
	}

}