<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Farm extends Eloquent {

	protected $table = 'farms';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function location()
	{
		return $this->hasOne('Location');
	}

	public function farmEquipments()
	{
		return $this->hasMany('FarmEquipment');
	}

}