<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Farmer extends Eloquent {

	protected $table = 'farmers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function group()
	{
		return $this->hasOne('FarmerGroup');
	}

	public function location()
	{
		return $this->hasOne('Location');
	}

	public function farms()
	{
		return $this->hasMany('Farm');
	}

	public function farmingEquipments()
	{
		return $this->hasMany('FarmingEquipment');
	}

	public function leaders()
	{
		return $this->hasMany('\GroupLeader');
	}

}