<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Farm extends Model 
{

    protected $table = 'farms';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function location()
    {
        return $this->hasOne('Location');
    }

    public function farmEquipments()
    {
        return $this->hasMany('FarmEquipment');
    }

}