<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Group extends Model 
{

    protected $table = 'groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function farmers()
    {
        return $this->hasMany('App\Models\FarmerGroup');
    }

    public function location()
    {
        return $this->hasOne('Location');
    }

    public function leaders()
    {
        return $this->hasMany('\GroupLeader');
    }

}